local super = require "NumberFormatter"

MetricFormatter = super:new()

local defaults = {
    decimals = 1,
    symbol = '',
}

local nilDefaults = {
}

function MetricFormatter:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    return self
end

function MetricFormatter:getFormatter()
    return NumberStringFormatter:metric()
end

function MetricFormatter:getArguments()
    return {
        self:getProperty('symbol'),
        self:getProperty('decimals'),
        1,
    }
end

function MetricFormatter:getInspectors()
    local list = List:new()
    local inspector, hook
    inspector = Inspector:new{
        type = 'Decimal',
    }
    inspector:addHook(self:getPropertyHook('decimals'), 'decimals')
    list:add(inspector)
    inspector = self:createInspector('string-short', {'symbol'}, 'Unit')
    list:add(inspector)
    return list
end

return MetricFormatter
